set nodos;
set arcos within nodos cross nodos;
param duracion {arcos} >= 0;


var camino {(i,j) in arcos} >=0,<=1,integer;

maximize DuraProyecto:
   sum {(i,j) in arcos} duracion[i,j]*camino[i,j];


subject to Balance {k in nodos: 0<k<18}:
     sum {(i,k) in arcos} camino[i,k] =  sum {(k,j) in arcos} camino[k,j];

subject to inicio: sum {(0,j) in arcos} camino[0,j]=1;



data chalet2.dat;
option solver cplex;
solve;
display camino;
